/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.options;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.screens.options.OptionsPanel;
import com.megacrit.cardcrawl.vfx.RestartForChangesEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ToggleButton {
    private static final Logger logger = LogManager.getLogger(ToggleButton.class.getName());
    private static final int W = 32;
    private float x;
    private float y;
    public Hitbox hb;
    public boolean enabled = true;
    private ToggleBtnType type;

    public ToggleButton(float x, float y, ToggleBtnType type) {
        this.x = x;
        this.y = Settings.OPTION_Y + y * Settings.scale;
        this.type = type;
        this.hb = new Hitbox(160.0f * Settings.scale, 32.0f * Settings.scale);
        this.hb.move(x + 64.0f * Settings.scale, this.y);
        this.enabled = this.getPref();
    }

    private boolean getPref() {
        switch (this.type) {
            case AMBIENCE_ON: {
                return OptionsPanel.soundPref.getBoolean("Ambience On");
            }
            case BLOCK_DMG: {
                return OptionsPanel.gamePref.getBoolean("Blocked Damage");
            }
            case CARD_TIP: {
                return OptionsPanel.gamePref.getBoolean("Card Tip");
            }
            case COMMON_TIP: {
                return OptionsPanel.gamePref.getBoolean("Common Tip");
            }
            case FULL_SCREEN: {
                return Settings.IS_FULLSCREEN;
            }
            case W_FULL_SCREEN: {
                return Settings.IS_W_FULLSCREEN;
            }
            case V_SYNC: {
                return Settings.IS_V_SYNC;
            }
            case HAND_CONF: {
                return OptionsPanel.gamePref.getBoolean("Hand Confirmation");
            }
            case POWER_TIP: {
                return OptionsPanel.gamePref.getBoolean("Power Tip");
            }
            case RELIC_TIP: {
                return OptionsPanel.gamePref.getBoolean("Relic Tip");
            }
            case SCREEN_SHAKE: {
                return OptionsPanel.gamePref.getBoolean("Screen Shake");
            }
            case SUM_DMG: {
                return OptionsPanel.gamePref.getBoolean("Summed Damage");
            }
            case UPLOAD_DATA: {
                return OptionsPanel.gamePref.getBoolean("Upload Data");
            }
            case PLAYTESTER_ART: {
                return OptionsPanel.gamePref.getBoolean("Playtester Art");
            }
        }
        return true;
    }

    public void update() {
        this.hb.update();
        if (this.hb.hovered && InputHelper.justClickedLeft) {
            InputHelper.justClickedLeft = false;
            this.toggle();
        }
    }

    public void toggle() {
        this.enabled = !this.enabled;
        switch (this.type) {
            case AMBIENCE_ON: {
                OptionsPanel.soundPref.putBoolean("Ambience On", this.enabled);
                OptionsPanel.soundPref.flush();
                Settings.AMBIANCE_ON = this.enabled;
                if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                    CardCrawlGame.mainMenuScreen.updateAmbienceVolume();
                } else {
                    AbstractDungeon.scene.updateAmbianceVolume();
                }
                logger.info("Ambience On: " + this.enabled);
                break;
            }
            case BLOCK_DMG: {
                OptionsPanel.gamePref.putBoolean("Blocked Damage", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.SHOW_DMG_BLOCK = this.enabled;
                logger.info("Show Blocked Damage: " + this.enabled);
                break;
            }
            case CARD_TIP: {
                OptionsPanel.gamePref.putBoolean("Card Tip", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.CARD_TIP = this.enabled;
                logger.info("Card Tips: " + this.enabled);
                break;
            }
            case COMMON_TIP: {
                OptionsPanel.gamePref.putBoolean("Common Tip", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.COMMON_TIP = this.enabled;
                logger.info("Common Tips: " + this.enabled);
                break;
            }
            case FULL_SCREEN: {
                boolean bl = Settings.IS_FULLSCREEN = !Settings.IS_FULLSCREEN;
                if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                    CardCrawlGame.mainMenuScreen.optionPanel.resoDropdown.setFullscreen(false);
                    CardCrawlGame.mainMenuScreen.optionPanel.effects.clear();
                    CardCrawlGame.mainMenuScreen.optionPanel.effects.add(new RestartForChangesEffect());
                } else {
                    AbstractDungeon.settingsScreen.panel.resoDropdown.setFullscreen(false);
                    AbstractDungeon.topLevelEffects.add(new RestartForChangesEffect());
                }
                if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                    if (CardCrawlGame.mainMenuScreen.optionPanel.wfsToggle.enabled) {
                        CardCrawlGame.mainMenuScreen.optionPanel.wfsToggle.enabled = false;
                    }
                } else if (AbstractDungeon.settingsScreen.panel.wfsToggle.enabled) {
                    AbstractDungeon.settingsScreen.panel.wfsToggle.enabled = false;
                }
                Settings.IS_W_FULLSCREEN = false;
                OptionsPanel.writeDisplayConfigFile(Gdx.graphics.getDisplayMode().width, Gdx.graphics.getDisplayMode().height, Settings.MAX_FPS, Settings.IS_FULLSCREEN, Settings.IS_W_FULLSCREEN, Settings.IS_V_SYNC);
                logger.info("Fullscreen: " + Settings.IS_FULLSCREEN);
                break;
            }
            case W_FULL_SCREEN: {
                boolean bl = Settings.IS_W_FULLSCREEN = !Settings.IS_W_FULLSCREEN;
                if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                    CardCrawlGame.mainMenuScreen.optionPanel.resoDropdown.setFullscreen(true);
                    CardCrawlGame.mainMenuScreen.optionPanel.effects.clear();
                    CardCrawlGame.mainMenuScreen.optionPanel.effects.add(new RestartForChangesEffect());
                } else {
                    AbstractDungeon.settingsScreen.panel.resoDropdown.setFullscreen(true);
                    AbstractDungeon.settingsScreen.panel.effects.clear();
                    AbstractDungeon.settingsScreen.panel.effects.add(new RestartForChangesEffect());
                }
                if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                    if (CardCrawlGame.mainMenuScreen.optionPanel.fsToggle.enabled) {
                        CardCrawlGame.mainMenuScreen.optionPanel.fsToggle.enabled = false;
                    }
                } else if (AbstractDungeon.settingsScreen.panel.fsToggle.enabled) {
                    AbstractDungeon.settingsScreen.panel.fsToggle.enabled = false;
                }
                Settings.IS_FULLSCREEN = false;
                OptionsPanel.writeDisplayConfigFile(Gdx.graphics.getDisplayMode().width, Gdx.graphics.getDisplayMode().height, Settings.MAX_FPS, Settings.IS_FULLSCREEN, Settings.IS_W_FULLSCREEN, Settings.IS_V_SYNC);
                logger.info("Borderless Fullscreen: " + Settings.IS_W_FULLSCREEN);
                break;
            }
            case V_SYNC: {
                boolean bl = Settings.IS_V_SYNC = !Settings.IS_V_SYNC;
                if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                    CardCrawlGame.mainMenuScreen.optionPanel.vSyncToggle.enabled = Settings.IS_V_SYNC;
                    CardCrawlGame.mainMenuScreen.optionPanel.effects.clear();
                    CardCrawlGame.mainMenuScreen.optionPanel.effects.add(new RestartForChangesEffect());
                } else {
                    AbstractDungeon.settingsScreen.panel.vSyncToggle.enabled = Settings.IS_V_SYNC;
                    AbstractDungeon.settingsScreen.panel.effects.clear();
                    AbstractDungeon.settingsScreen.panel.effects.add(new RestartForChangesEffect());
                }
                OptionsPanel.writeDisplayConfigFile(Settings.SAVED_WIDTH, Settings.SAVED_HEIGHT, Settings.MAX_FPS, Settings.IS_FULLSCREEN, Settings.IS_W_FULLSCREEN, Settings.IS_V_SYNC);
                logger.info("V Sync: " + Settings.IS_V_SYNC);
                break;
            }
            case HAND_CONF: {
                OptionsPanel.gamePref.putBoolean("Hand Confirmation", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.FAST_HAND_CONF = this.enabled;
                logger.info("Hand Confirmation: " + this.enabled);
                break;
            }
            case POWER_TIP: {
                OptionsPanel.gamePref.putBoolean("Power Tip", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.POWER_TIP = this.enabled;
                logger.info("Power Tips: " + this.enabled);
                break;
            }
            case RELIC_TIP: {
                OptionsPanel.gamePref.putBoolean("Relic Tip", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.RELIC_TIP = this.enabled;
                logger.info("Relic Tips: " + this.enabled);
                break;
            }
            case SCREEN_SHAKE: {
                OptionsPanel.gamePref.putBoolean("Screen Shake", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.SCREEN_SHAKE = this.enabled;
                logger.info("Screen Shake: " + this.enabled);
                break;
            }
            case SUM_DMG: {
                OptionsPanel.gamePref.putBoolean("Summed Damage", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.SHOW_DMG_SUM = this.enabled;
                logger.info("Display Summed Damage: " + this.enabled);
                break;
            }
            case UPLOAD_DATA: {
                OptionsPanel.gamePref.putBoolean("Upload Data", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.UPLOAD_DATA = this.enabled;
                logger.info("Upload Data: " + this.enabled);
                break;
            }
            case PLAYTESTER_ART: {
                OptionsPanel.gamePref.putBoolean("Playtester Art", this.enabled);
                OptionsPanel.gamePref.flush();
                Settings.PLAYTESTER_ART_MODE = this.enabled;
                logger.info("Playtester Art: " + this.enabled);
                break;
            }
        }
    }

    public void render(SpriteBatch sb) {
        if (this.hb.hovered) {
            sb.setColor(Color.CYAN);
        } else if (this.enabled) {
            sb.setColor(Color.LIGHT_GRAY);
        } else {
            sb.setColor(Color.WHITE);
        }
        sb.draw(ImageMaster.OPTION_TOGGLE, this.x - 16.0f, this.y - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
        if (this.enabled) {
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.OPTION_TOGGLE_ON, this.x - 16.0f, this.y - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
        }
        this.hb.render(sb);
    }

    public static enum ToggleBtnType {
        FULL_SCREEN,
        W_FULL_SCREEN,
        SCREEN_SHAKE,
        AMBIENCE_ON,
        SUM_DMG,
        BLOCK_DMG,
        HAND_CONF,
        COMMON_TIP,
        CARD_TIP,
        POWER_TIP,
        RELIC_TIP,
        UPLOAD_DATA,
        V_SYNC,
        PLAYTESTER_ART;

    }
}

